# SEE-OoD

Source code for paper **SEE-OoD: Supervised Exploration for Enhanced Out-of-Distribution Detection**.

## Requirements

Please install packages with specific versions using the code below:

```
pip install -r requirements.txt
```

If there are other packages that are also required. Please install them accordingly based on error code.

## Sample Training OoD data

1. Go to `config/sampling.yaml` and set the configuration according to the provided instructions.
2. Then go to `jobs/sampling.sh` and modify the number of samples you want to sample for each OoD class (i.e. `n_ood`).
3. Run the following:

```
bash jobs/sampling.sh
```

## Train SEE-OoD detector

1. Go to `config/run.yaml` and set the training configuration according to the provided instructions.
2. Go to `jobs/run.sh` to configure the logging file path and the number of OoD samples you want to use in the training stage (i.e. `n_ood`). Note that OoD data must be sampled before running the training scripts.
3. Run the following:

```
bash jobs/run.sh
```

## Results

Experimental results can be found in the `checkpoint/` folder.

- `log/`: experimental results, training logs, and evaluation logs.
- `OOD-Sample/`: sampled OoD data.
- `<dataset-name>/`: model checkpoints for `<dataset-name>` experiments.
